#include <stdio.h>
#include "simio.h"

/*----------------------------------------------------------------------*/
/* Special function registers						*/
/*----------------------------------------------------------------------*/
extern void	__sfr__(int address);	/* SFR address attribute	*/
extern volatile int  __attribute__((__sfr__(0x20C))) U1MOD;
extern volatile int  __attribute__((__sfr__(0x20E))) U1STA;
extern volatile char __attribute__((__sfr__(0x210))) TX1REG;
extern volatile char __attribute__((__sfr__(0x212))) RX1REG;
extern volatile int  __attribute__((__sfr__(0x214))) BRG1;
#define	SPEN	0x8000u
#define	TXEN	0x0400u
#define	TRMT	0x0100u
#define	TXBF	0x0200u
#define	RCDA	0x0001u
/*----------------------------------------------------------------------*/
static void __inline__
doread(PSIMIO psimio)
{
  	__asm__(".pword 0xDAC000" :: "r" (psimio));
}
int __attribute__((__weak__))
read(int handle, void *buffer, unsigned int len)
{
	int i;
	SIMIO simio;

	switch (handle)
	{
	case 0:
		if (_Files[0]->_Lockno == 0)
		{
			if ((U1MOD & SPEN) == 0)
			{
				BRG1 = 0;
				U1MOD |= SPEN;
			}
			for (i = len; i; --i)
			{
				int nTimeout;
	
				/*
				** Timeout is 16 cycles per 10-bit char
				*/
				nTimeout = 16*10;
				while (((U1STA & RCDA) == 0) && nTimeout)
				{
					--nTimeout;
				}
				if ((U1STA & RCDA) == 0)
				{
					break;
				}
				*(char*)buffer++ = RX1REG;
			}
			len -= i;
			break;
		}
	default:
		simio.method = SIM_READ;
		simio.u.read.handle = handle;
		simio.u.read.buffer = buffer;
		simio.u.read.len = len;
		doread(&simio);

		len = simio.u.read.len;
		break;
	}
	return(len);
}
